<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>School Admin Dashboard</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    function toggleSubmenu(id) {
      const submenu = document.getElementById(id);
      submenu.classList.toggle('hidden');

      // Get all links except Dashboard
      const allLinks = document.querySelectorAll('nav > a:not([onclick])');
      allLinks.forEach((link) => {
        link.classList.toggle('hidden'); // Toggle visibility of other links
      });
    }

    function toggleSidebar() {
      const sidebar = document.getElementById('sidebar');
      sidebar.classList.toggle('hidden');
    }
  </script>
</head>
<body class="bg-gray-100">

<!-- Sidebar -->
<div class="flex h-screen">
  <!-- Navigation -->
  <div id="sidebar" class="w-64 bg-blue-900 text-white md:block">
    <div class="p-6">
      <h1 class="text-2xl font-bold">Admin Panel</h1>
    </div>
    <nav class="mt-6">
      <a href="#" onclick="toggleSubmenu('dashboardSubmenu')" class="block p-4 hover:bg-blue-800">
        Dashboard
      </a>
      <div id="dashboardSubmenu" class="submenu hidden pl-6">
        <a href="admin_dashboard.php" class="block p-2 hover:bg-blue-700">Admin Dashboard</a>
        <a href="admin_attendancesection.php" class="block p-2 hover:bg-blue-700">Attendance Dashboard</a>
        <a href="admin_classteachersection.php" class="block p-2 hover:bg-blue-700">Class Teacher Dashboard</a>
        <a href="admin_studentsection.php" class="block p-2 hover:bg-blue-700">Student Dashboard</a>
        <a href="admin_teachersection.php" class="block p-2 hover:bg-blue-700">Teachers Dashboard</a>
        <a href="admin_fieldapplication.php" class="block p-2 hover:bg-blue-700">Field Application Dashboard</a>
        <a href="admin_leaveapplication.php" class="block p-2 hover:bg-blue-700">Leave Application Dashboard</a>
        <a href="admin_pastpapersection.php" class="block p-2 hover:bg-blue-700">Past Papers Dashboard</a>
        <a href="admin_schoolresults_section.php" class="block p-2 hover:bg-blue-700">School Results Dashboard</a>
        <a href="admin_announcements_section.php" class="block p-2 hover:bg-blue-700">Announcements Dashboard</a>
        <a href="admin_fees_section.php" class="block p-2 hover:bg-blue-700">Fees Dashboard</a>
        <a href="admin_library_section.php" class="block p-2 hover:bg-blue-700">Library Section</a>
      </div>
      
      <a href="#" class="block p-4 hover:bg-blue-800">Students</a>
      <a href="#" class="block p-4 hover:bg-blue-800">Attendance</a>
      <a href="#" class="block p-4 hover:bg-blue-800">Results</a>
      <a href="admin_fees_payments.php" class="block p-4 hover:bg-blue-800">Payments</a>
      <a href="admin_view_fees_amount.php" class="block p-4 hover:bg-blue-800">View Fees Amount</a>
      <a href="#" class="block p-4 hover:bg-blue-800">Settings</a>
      <a href="#" class="block p-4 hover:bg-blue-800">Activity Logs</a>
      <a href="#" class="block p-4 hover:bg-blue-800">Login History</a>
      <a href="admin_update_classes.php" class="block p-4 hover:bg-blue-800">Update Classes</a>
      <a href="admin_view_positions.php" class="block p-4 hover:bg-blue-800">View school positions</a>
      <a href="admin_view_logs.php" class="block p-4 hover:bg-blue-800">View Logs</a>
    </nav>
  </div>


  <!-- Main Content -->
  <div class="flex-1 p-6">
    <!-- Dashboard Header -->
    <div class="flex justify-between items-center mb-6">
      <h2 class="text-2xl font-semibold">Mwalongo Secondary School Dashboard</h2>
      <a href="school_logout.php" class="bg-blue-500 text-white px-4 py-2 rounded">Logout</a>
    </div>

    <!-- Stats Overview -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Students</h3>
        <p class="text-3xl font-bold">1,500</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Teachers</h3>
        <p class="text-3xl font-bold">15</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Field Applications</h3>
        <p class="text-3xl font-bold">08</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Leave Applications</h3>
        <p class="text-3xl font-bold">10,000</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Job Applications</h3>
        <p class="text-3xl font-bold">25</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Classes in Session</h3>
        <p class="text-3xl font-bold">8</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Active Students</h3>
        <p class="text-3xl font-bold">300</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Attendance</h3>
        <p class="text-3xl font-bold">280</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Announcements</h3>
        <p class="text-3xl font-bold">5</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Disciplinary Cases</h3>
        <p class="text-3xl font-bold">2</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">New Admissions</h3>
        <p class="text-3xl font-bold">20</p>
      </div>
      <div class="p-6 bg-white rounded-lg shadow-md">
        <h3 class="text-lg font-semibold">Exams Scheduled</h3>
        <p class="text-3xl font-bold">10</p>
      </div>
    </div>

    <footer class="bg-blue-900 text-white text-center py-4 mt-6">
      <div class="container">
        <p class="mb-0">© <script>document.write(new Date().getFullYear())</script> Mwalongo Secondary School. All rights reserved.</p>
        <p class="mb-0">P.O. Box 123, Dar es Salaam, Tanzania</p>
      </div>
    </footer>
  </div>
</div>

<!-- Include Font Awesome for social media icons (Optional) -->
<script src="https://kit.fontawesome.com/a076d05399.js"></script>

</body>
</html>